<?php
require_once __DIR__ . '/Personne.php';
require_once __DIR__ . '/Mentaliste.php';
require_once __DIR__ . '/Operateur.php';
require_once __DIR__ . '/Chasseur.php';
require_once __DIR__ . '/Drone.php';

class Vaisseau {
    private $idJoueur;
    private $pv;
    private $pvMax = 100;
    private $energie;
    private $energieMax = 10;
    private $positionX;
    private $positionY;
    private $equipage = [];
    private $equipageMax = 2;
    
    public $bloqueMouvement = 0; 
    public $bloqueTir = 0;       

    public $dronesStock = [];
    public $dronesActifs = [];
    public $bouclier = 0;
    public $malusPrecisionAdverse = 0; 

    public function __construct($idJoueur, $x, $y) {
        $this->idJoueur = $idJoueur;
        $this->positionX = $x;
        $this->positionY = $y;
        $this->pv = $this->pvMax;
        $this->energie = 5;
        
        $roles = ['Mentaliste', 'Operateur', 'Chasseur'];
        $this->equipage[] = new $roles[array_rand($roles)]();
    }

    // --- DÉPLACEMENT (MODIFIÉ : GESTION COLLISION) ---
    public function seDeplacer($x, $y, $phase, $advX, $advY) {
        if ($this->bloqueMouvement > 0) return "Immobilisé !";
        
        // Vérification Collision Adversaire
        if ($x == $advX && $y == $advY) return "Case occupée par l'adversaire.";

        if ($x != $this->positionX && $y != $this->positionY) return "Lignes droites uniquement.";
        
        $dist = abs($this->positionX - $x) + abs($this->positionY - $y);
        if ($dist < 1 || $dist > 3) return "Distance invalide.";
        if ($this->energie < $dist) return "Manque d'énergie.";
        
        if ($phase === 1) {
            if ($this->idJoueur === 1 && $y > 3) return "Zone adverse interdite.";
            if ($this->idJoueur === 2 && $y < 4) return "Zone adverse interdite.";
        }

        $this->energie -= $dist;
        $this->positionX = $x;
        $this->positionY = $y;
        return true;
    }

    // --- RECHARGE ---
    public function rechargerEnergie($montant) { 
        if ($this->bloqueMouvement > 0) return; 
        $this->energie = min($this->energie + $montant, $this->energieMax); 
    }

    // --- COMBAT ---
    public function subirDegats($montant) {
        $pvAvant = $this->pv;
        if ($this->bouclier > 0) {
            $reste = $montant - $this->bouclier;
            $this->bouclier -= $montant;
            if ($this->bouclier < 0) $this->bouclier = 0;
            if ($reste > 0) $montant = $reste; else $montant = 0;
        }
        $this->pv = max(0, $this->pv - $montant);
        return $pvAvant - $this->pv;
    }

    public function tirer(Vaisseau $cible, $type) {
        if ($this->bloqueTir > 0) return "Armes brouillées !";
        
        $cout = ($type === 'laser') ? 2 : 3;
        $degatsBase = ($type === 'laser') ? 15 : 35;
        $degatsTotal = $degatsBase + $this->getBonusDegats();
        $precision = ($type === 'laser') ? 90 : 50;
        $precisionEffective = $precision - $cible->malusPrecisionAdverse;

        if ($this->energie < $cout) return "Pas assez d'énergie.";
        $this->energie -= $cout;

        if (rand(1, 100) <= $precisionEffective) {
            return $cible->subirDegats($degatsTotal);
        } else {
            return -1;
        }
    }

    // --- DRONES (DÉPLOIEMENT AVEC VÉRIF) ---
    public function deployerDrone($index) {
        // Le contrôle est fait ici aussi par sécurité
        if ($this->bloqueMouvement > 0) return false; 

        if (!isset($this->dronesStock[$index])) return false;
        $drone = $this->dronesStock[$index];
        
        if ($drone->type === 'def') { $this->bouclier += $drone->valeur; $this->dronesActifs[] = $drone; }
        elseif ($drone->type === 'atk') { $this->dronesActifs[] = $drone; }
        elseif ($drone->type === 'esq') { $this->malusPrecisionAdverse += $drone->valeur; $this->dronesActifs[] = $drone; }
        elseif ($drone->type === 'rep') { $this->pv = min($this->pv + $drone->valeur, $this->pvMax); }
        
        unset($this->dronesStock[$index]);
        $this->dronesStock = array_values($this->dronesStock);
        return true;
    }

    // --- UTILS (INCHANGÉS) ---
    public function getBonusDegats() {
        $bonus = 0; foreach ($this->dronesActifs as $drone) if ($drone->type === 'atk') $bonus += $drone->valeur; return $bonus;
    }
    public function debutDuTour() {
        if ($this->bloqueMouvement > 0) $this->bloqueMouvement--;
        if ($this->bloqueTir > 0) $this->bloqueTir--;
        foreach ($this->equipage as $membre) $membre->passerTour();
        foreach ($this->dronesActifs as $k => $d) {
            $d->passerTour();
            if(!$d->estActif()) { 
                if($d->type=='def') $this->bouclier=0; 
                if ($d->type === 'esq') $this->malusPrecisionAdverse -= $d->valeur; 
                unset($this->dronesActifs[$k]); 
            }
        }
        $this->dronesActifs = array_values($this->dronesActifs);
    }
    public function estDetruit() { return $this->pv <= 0; }
    public function getId() { return $this->idJoueur; }
    public function getPos() { return ['x' => $this->positionX, 'y' => $this->positionY]; }
    public function getEnergie() { return $this->energie; }
    public function getPv() { return $this->pv; }
    public function getEquipage() { return $this->equipage; }
    public function getCasesAccessibles($phase) {
        $cases = []; if ($this->bloqueMouvement > 0) return $cases; 
        $directions = [[0, 1], [0, -1], [1, 0], [-1, 0]];
        foreach ($directions as $dir) { for ($i = 1; $i <= 3; $i++) {
            if ($this->energie < $i) break; $cibleX = $this->positionX + ($dir[0] * $i); $cibleY = $this->positionY + ($dir[1] * $i);
            if ($cibleX < 0 || $cibleX > 7 || $cibleY < 0 || $cibleY > 7) continue;
            if ($phase === 1) { if ($this->idJoueur === 1 && $cibleY > 3) continue; if ($this->idJoueur === 2 && $cibleY < 4) continue; }
            $cases[] = ['x' => $cibleX, 'y' => $cibleY]; } } return $cases; }
    public function ramasserDrone(Drone $drone) { $this->dronesStock[] = $drone; }
    public function ajouterMembre(Personne $personne) { if (count($this->equipage) >= $this->equipageMax) return false; $this->equipage[] = $personne; return true; }
    public function aUnMembrePret($roleClass) { foreach ($this->equipage as $index => $membre) if ($membre instanceof $roleClass && $membre->estPret()) return $index; return -1; }
    public function utiliserCompetence($index) { if (isset($this->equipage[$index])) { $m = $this->equipage[$index]; if($m instanceof Chasseur) $m->aTire(); else $m->activerCooldown(); } }
    public function utiliserMentaliste(Vaisseau $cible, $indexMembre) { $this->equipage[$indexMembre]->activerCooldown(); $cible->bloqueMouvement = 2; $cible->bloqueTir = 2; }
    public function utiliserOperateur(Vaisseau $cible, $indexMembre) { $this->equipage[$indexMembre]->activerCooldown(); $cible->bloqueTir = 3; }
    public function tuerMembre($indexCible) { if (isset($this->equipage[$indexCible])) { unset($this->equipage[$indexCible]); $this->equipage = array_values($this->equipage); return true; } return false; }
}