<?php
require_once __DIR__ . '/Partie.php';

class IA {
    public static function jouerTour(Partie $partie, $roleIA) {
        $ia = ($roleIA == 1) ? $partie->joueur1 : $partie->joueur2;
        $adversaire = ($roleIA == 1) ? $partie->joueur2 : $partie->joueur1;

        // 1. Si immobilisé, on passe
        if ($ia->bloqueMouvement > 0) {
             $ia->rechargerEnergie(3);
             $partie->nouveauMessage("L'IA passe son tour (Immobilisée).", 0);
             $partie->passerTour();
             return;
        }

        // 2. Déployer des drones si utile
        if (!empty($ia->dronesStock)) {
            foreach ($ia->dronesStock as $idx => $drone) {
                // Défensif ou Réparation : on utilise tout de suite
                if ($drone->type === 'def' || $drone->type === 'rep') {
                    if ($ia->deployerDrone($idx)) {
                        $partie->nouveauMessage("🛸 L'IA déploie un drone de soutien.", 0);
                        $partie->passerTour();
                        return;
                    }
                }
                // Attaque : seulement si on a de l'énergie pour tirer après (stratégie simple)
                if ($drone->type === 'atk' && $ia->getEnergie() >= 5) {
                    if ($ia->deployerDrone($idx)) {
                        $partie->nouveauMessage("🛸 L'IA déploie un drone d'attaque.", 0);
                        $partie->passerTour();
                        return;
                    }
                }
            }
        }

        // 3. Attaquer si possible (Phase 2)
        if ($partie->phase === 2 && $ia->bloqueTir == 0) {
            // Priorité Plasma
            if ($ia->getEnergie() >= 3) {
                $pv = $ia->tirer($adversaire, 'plasma');
                if ($pv > -1) {
                    $partie->nouveauMessage("💥 L'IA tire au PLASMA ! Joueur adverse perd $pv PV.", 0);
                    $partie->verifierFinDePartie();
                    if (!$partie->gagnant) $partie->passerTour();
                    return;
                } else {
                     $partie->nouveauMessage("💨 L'IA tire au PLASMA et rate !", 0);
                     $partie->passerTour();
                     return;
                }
            } 
            // Sinon Laser
            elseif ($ia->getEnergie() >= 2) {
                 $pv = $ia->tirer($adversaire, 'laser');
                 if ($pv > -1) {
                    $partie->nouveauMessage("💥 L'IA tire au LASER ! Joueur adverse perd $pv PV.", 0);
                    $partie->verifierFinDePartie();
                    if (!$partie->gagnant) $partie->passerTour();
                    return;
                } else {
                     $partie->nouveauMessage("💨 L'IA tire au LASER et rate !", 0);
                     $partie->passerTour();
                     return;
                }
            }
        }

        // 4. Se déplacer
        // On cherche à se rapprocher des bonus ou juste bouger
        $cases = $ia->getCasesAccessibles($partie->phase);
        if (!empty($cases)) {
            $advPos = $adversaire->getPos();
            
            // Stratégie : aller vers un bonus si possible
            foreach ($cases as $c) {
                foreach ($partie->bonusListe as $b) {
                    if ($b->x == $c['x'] && $b->y == $c['y']) {
                        // Tenter ce mouvement
                        if ($c['x'] == $advPos['x'] && $c['y'] == $advPos['y']) continue;
                        $res = $ia->seDeplacer($c['x'], $c['y'], $partie->phase, $advPos['x'], $advPos['y']);
                        if ($res === true) {
                            $partie->verifierBonus($ia);
                            $partie->nouveauMessage("L'IA se déplace vers un bonus.", 0);
                            $partie->passerTour();
                            return;
                        }
                    }
                }
            }

            // Sinon mouvement aléatoire
            shuffle($cases);
            foreach ($cases as $c) {
                if ($c['x'] == $advPos['x'] && $c['y'] == $advPos['y']) continue;
                
                $res = $ia->seDeplacer($c['x'], $c['y'], $partie->phase, $advPos['x'], $advPos['y']);
                if ($res === true) {
                    $partie->verifierBonus($ia);
                    $partie->nouveauMessage("L'IA se déplace.", 0);
                    $partie->passerTour();
                    return;
                }
            }
        }

        // 5. Si rien d'autre, recharger
        $ia->rechargerEnergie(3);
        $partie->nouveauMessage("L'IA se repose (+3⚡).", 0);
        $partie->passerTour();
    }
}
