<?php
require_once __DIR__ . '/Personne.php';

class Chasseur extends Personne {
    private $aDejaTire = false;

    public function __construct() {
        parent::__construct("Chasseur de Prime", 70, 999);
        $this->cooldown = 3; 
    }

    public function aTire() {
        $this->aDejaTire = true;
    }

    public function estPret() {
        return !$this->aDejaTire && $this->cooldown === 0;
    }

    public function getStatus() {
        if ($this->aDejaTire) return "(Munitions épuisées)";
        if ($this->cooldown > 0) return "(Chargement : {$this->cooldown}t)";
        return "(Prêt - 1 tir max)";
    }
}