<?php
require_once 'db.php';
// Messages
$message = '';
$success = '';
// Ajout d'un utilisateur
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_user') {
    $nom = $conn->real_escape_string($_POST['nom']);
    $prenom = $conn->real_escape_string($_POST['prenom']);
    $email = $conn->real_escape_string($_POST['email']);
    $role = in_array($_POST['role'], ['utilisateur','administrateur']) ? $_POST['role'] : 'utilisateur';
    $password = $_POST['password'];
    if (!$nom || !$prenom || !$email || !$password) {
        $message = "Tous les champs sont obligatoires.";
    } else {
        $exists = $conn->query("SELECT id FROM utilisateurs WHERE email = '$email'")->fetch_assoc();
        if ($exists) {
            $message = "Cet email est déjà utilisé.";
        } else {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $conn->query("INSERT INTO utilisateurs (nom, prenom, email, role, actif, password) VALUES ('$nom', '$prenom', '$email', '$role', 1, '$hash')");
            $success = "Utilisateur ajouté avec succès.";
        }
    }
}
// Recherche et filtres
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';
$role = isset($_GET['role']) ? $conn->real_escape_string($_GET['role']) : '';

// Bannir/débannir
if (isset($_POST['action']) && $_POST['action'] === 'toggle_active' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $actif = (int)$_POST['actif'];
    $conn->query("UPDATE utilisateurs SET actif = " . ($actif ? 0 : 1) . " WHERE id = $id");
    header('Location: utilisateurs.php');
    exit();
}

// Suppression d'un utilisateur
if (isset($_POST['action']) && $_POST['action'] === 'delete_user' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $conn->query("DELETE FROM utilisateurs WHERE id = $id");
    header('Location: utilisateurs.php');
    exit();
}

// Construction de la requête
$where = [];
if ($search) {
    $where[] = "(nom LIKE '%$search%' OR prenom LIKE '%$search%' OR email LIKE '%$search%')";
}
if ($role) {
    $where[] = "role = '$role'";
}
$where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';
$utilisateurs = $conn->query("SELECT * FROM utilisateurs $where_sql ORDER BY nom, prenom");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Utilisateurs</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .banni { color: #d63031; font-weight: bold; }
        .admin { color: #6c5ce7; font-weight: bold; }
    </style>
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion des Utilisateurs</h1>
        <?php if ($message): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
        <?php endif; ?>
        <div class="card">
            <h2>Ajouter un utilisateur</h2>
            <form method="post">
                <input type="hidden" name="action" value="add_user">
                <div class="form-group">
                    <label>Nom</label>
                    <input type="text" name="nom" required>
                </div>
                <div class="form-group">
                    <label>Prénom</label>
                    <input type="text" name="prenom" required>
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" required>
                </div>
                <div class="form-group">
                    <label>Mot de passe</label>
                    <input type="password" name="password" required>
                </div>
                <div class="form-group">
                    <label>Rôle</label>
                    <select name="role">
                        <option value="utilisateur">Utilisateur</option>
                        <option value="administrateur">Administrateur</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Créer l'utilisateur</button>
            </form>
        </div>
        <form method="get" style="margin-bottom:1.5rem; display:flex; gap:1rem; align-items:center;">
            <input type="text" name="search" placeholder="Recherche nom, prénom ou email" value="<?= htmlspecialchars($search) ?>">
            <select name="role">
                <option value="">Tous les rôles</option>
                <option value="utilisateur" <?= $role === 'utilisateur' ? 'selected' : '' ?>>Utilisateur</option>
                <option value="administrateur" <?= $role === 'administrateur' ? 'selected' : '' ?>>Administrateur</option>
            </select>
            <button type="submit" class="btn btn-primary">Filtrer</button>
        </form>
        <div class="card">
            <h2>Liste des utilisateurs</h2>
            <table>
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Prénom</th>
                        <th>Email</th>
                        <th>Rôle</th>
                        <th>Statut</th>
                        <th>Mot de passe (hashé)</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($u = $utilisateurs->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($u['nom']) ?></td>
                        <td><?= htmlspecialchars($u['prenom']) ?></td>
                        <td><?= htmlspecialchars($u['email']) ?></td>
                        <td class="<?= $u['role'] === 'administrateur' ? 'admin' : '' ?>"><?= htmlspecialchars(ucfirst($u['role'])) ?></td>
                        <td class="<?= !$u['actif'] ? 'banni' : '' ?>"><?= $u['actif'] ? 'Actif' : 'Banni' ?></td>
                        <td style="font-size:0.85em;word-break:break-all;max-width:200px;overflow-x:auto;">
                            <?= htmlspecialchars($u['password']) ?>
                        </td>
                        <td>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="id" value="<?= $u['id'] ?>">
                                <input type="hidden" name="actif" value="<?= $u['actif'] ?>">
                                <button type="submit" name="action" value="toggle_active" class="btn <?= $u['actif'] ? 'btn-danger' : 'btn-success' ?>">
                                    <?= $u['actif'] ? 'Bannir' : 'Débannir' ?>
                                </button>
                            </form>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Supprimer ce compte utilisateur ?');">
                                <input type="hidden" name="id" value="<?= $u['id'] ?>">
                                <button type="submit" name="action" value="delete_user" class="btn btn-danger">Supprimer</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>
</body>
</html> 