<?php
require_once 'db.php';
session_start();
if (!isset($_GET['id'])) { header('Location: client.php'); exit(); }
if (!isset($_SESSION['user_id'])) { header('Location: client_login.php'); exit(); }
$id = (int)$_GET['id'];
$user_id = (int)$_SESSION['user_id'];
$spectacle = $conn->query("SELECT * FROM spectacles WHERE id = $id")->fetch_assoc();
if (!$spectacle) { header('Location: client.php'); exit(); }
// Ajout/suppression favori
$favori_existe = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['favori_id'])) {
    $fid = (int)$_POST['favori_id'];
    $check = $conn->query("SELECT id FROM favoris WHERE utilisateur_id = $user_id AND spectacle_id = $fid")->fetch_assoc();
    if (!$check) {
        $conn->query("INSERT INTO favoris (utilisateur_id, spectacle_id) VALUES ($user_id, $fid)");
    } else {
        $conn->query("DELETE FROM favoris WHERE utilisateur_id = $user_id AND spectacle_id = $fid");
    }
    // Rafraîchir pour éviter le repost
    header("Location: spectacle.php?id=$id");
    exit();
}
// Vérifier si déjà favori
$favori_existe = $conn->query("SELECT id FROM favoris WHERE utilisateur_id = $user_id AND spectacle_id = $id")->fetch_assoc() ? true : false;
// Chercher toutes les représentations avec coordonnées (donc affichées sur la map)
$reps = $conn->query("SELECT r.*, sa.nom AS salle, sa.ville, sa.latitude, sa.longitude FROM representations r JOIN salles sa ON r.salle_id = sa.id WHERE r.spectacle_id = $id AND sa.latitude IS NOT NULL AND sa.longitude IS NOT NULL ORDER BY r.date ASC, r.heure ASC");
// Réservation d'une place
if (isset($_POST['reserver_rep_id'])) {
    $rep_id = (int)$_POST['reserver_rep_id'];
    $user = $conn->query("SELECT * FROM utilisateurs WHERE id = $user_id")->fetch_assoc();
    if ($user) {
        $nom = $conn->real_escape_string($user['nom']);
        $email = $conn->real_escape_string($user['email']);
        $conn->query("INSERT INTO reservations (representation_id, nom_client, email_client, nb_places) VALUES ($rep_id, '$nom', '$email', 1)");
    }
    header("Location: mes_reservations.php");
    exit();
}
// --- Gestion des avis ---
// Ajout d'un avis
$avis_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajouter_avis'])) {
    $titre_avis = trim($_POST['titre_avis'] ?? '');
    $note_avis = (int)($_POST['note_avis'] ?? 0);
    $commentaire_avis = trim($_POST['commentaire_avis'] ?? '');
    if ($note_avis < 1 || $note_avis > 5) $note_avis = 1;
    if (mb_strlen($titre_avis) < 2 || mb_strlen($titre_avis) > 100) {
        $avis_message = "Le titre doit faire entre 2 et 100 caractères.";
    } elseif (mb_strlen($commentaire_avis) < 2 || mb_strlen($commentaire_avis) > 300) {
        $avis_message = "Le commentaire doit faire entre 2 et 300 caractères.";
    } else {
        // Empêcher un utilisateur de poster plusieurs avis sur le même spectacle
        $existe = $conn->query("SELECT id FROM avis WHERE id_spectacle=$id AND id_utilisateur=$user_id")->fetch_assoc();
        if ($existe) {
            $avis_message = "Vous avez déjà posté un avis pour ce spectacle.";
        } else {
            $titre_avis = htmlspecialchars($titre_avis);
            $commentaire_avis = htmlspecialchars($commentaire_avis);
            $conn->query("INSERT INTO avis (id_spectacle, id_utilisateur, note, titre, commentaire) VALUES ($id, $user_id, $note_avis, '$titre_avis', '$commentaire_avis')");
            header("Location: spectacle.php?id=$id#avis");
            exit();
        }
    }
}
// Signalement d'un avis
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['signaler_avis_id'])) {
    $avis_id = (int)$_POST['signaler_avis_id'];
    $conn->query("UPDATE avis SET signale=1 WHERE id=$avis_id");
    // Envoi d'un mail à l'admin (simple)
    $admin_mail = 'admin@tonsite.fr';
    $avis_info = $conn->query("SELECT a.*, u.email FROM avis a JOIN utilisateurs u ON a.id_utilisateur = u.id WHERE a.id=$avis_id")->fetch_assoc();
    if ($avis_info) {
        $sujet = "[Signalement] Avis à modérer sur un spectacle";
        $message = "Un avis a été signalé :\n\n" .
            "Spectacle ID: $id\n" .
            "Utilisateur: " . $avis_info['email'] . "\n" .
            "Note: " . $avis_info['note'] . "\n" .
            "Titre: " . $avis_info['titre'] . "\n" .
            "Commentaire: " . $avis_info['commentaire'] . "\n" .
            "Date: " . $avis_info['date'] . "\n";
        @mail($admin_mail, $sujet, $message);
    }
    $avis_message = "Merci, l'avis a été signalé.";
}
// Récupérer les avis
$avis = $conn->query("SELECT a.*, u.prenom, u.nom FROM avis a JOIN utilisateurs u ON a.id_utilisateur = u.id WHERE a.id_spectacle = $id ORDER BY a.date DESC");
$nb_avis = $avis->num_rows;
$moyenne = $conn->query("SELECT AVG(note) as avg_note FROM avis WHERE id_spectacle = $id")->fetch_assoc();
$moyenne_note = $moyenne && $moyenne['avg_note'] ? round($moyenne['avg_note'], 2) : 0;
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($spectacle['titre']) ?> - Détail</title>
    <link rel="stylesheet" href="client_pages.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <style>
    body {
        min-height: 100vh;
        margin: 0;
        background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
        font-family: 'Montserrat', Arial, sans-serif;
        color: #fff;
    }
    #mask-bg {
        position: fixed;
        top: 0; left: 0;
        width: 100vw; height: 100vh;
        z-index: 0;
        pointer-events: none;
    }
    .main-spectacle-container {
        display: flex;
        justify-content: center;
        align-items: flex-start;
        min-height: 100vh;
        padding: 3.5rem 0 2.5rem 0;
        animation: fadeInUp 0.8s cubic-bezier(.4,2,.3,1);
        position: relative;
        z-index: 2;
    }
    @keyframes fadeInUp {
        from { opacity: 0; transform: translateY(40px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .spectacle-card-modern {
        background: rgba(255,255,255,0.13);
        border: 1px solid rgba(255,255,255,0.18);
        border-radius: 1.5em;
        box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        display: flex;
        flex-direction: row;
        max-width: 540px;
        width: 100%;
        padding: 1.5rem 1.5rem 1.5rem 1.2rem;
        gap: 1.5rem;
        align-items: flex-start;
        margin: 0 auto;
        position: relative;
    }
    .spectacle-img-modern {
        width: 120px;
        height: 170px;
        border-radius: 1.2em;
        background: #232526;
        overflow: hidden;
        flex-shrink: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 12px #0004;
    }
    .spectacle-img-modern img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 1.2em;
    }
    .spectacle-infos-modern {
        flex: 1;
        display: flex;
        flex-direction: column;
        gap: 0.7rem;
    }
    .spectacle-infos-modern h1 {
        font-size: 1.35rem;
        font-weight: 800;
        margin: 0 0 0.3rem 0;
        color: #FFD600;
        letter-spacing: 1px;
        text-shadow: 0 2px 8px #0006;
    }
    .spectacle-infos-modern .desc {
        font-size: 1.05rem;
        color: #f0f0f0;
        margin-bottom: 0.2rem;
        text-shadow: 0 1px 4px #000;
    }
    .spectacle-infos-modern .spectacle-rating {
        margin: 0.2rem 0 0.2rem 0;
        font-size: 1.1rem;
        color: #FFD600;
        display: flex;
        align-items: center;
        gap: 0.4rem;
    }
    .spectacle-infos-modern .spectacle-actions {
        display: flex;
        gap: 0.7rem;
        margin-top: 0.5rem;
        flex-wrap: wrap;
    }
    .spectacle-btn-modern {
        background: #e50914;
        color: #fff;
        border: none;
        border-radius: 1.2rem;
        padding: 0.7rem 1.5rem;
        font-size: 1.05rem;
        font-weight: 700;
        cursor: pointer;
        transition: background 0.2s, box-shadow 0.2s;
        box-shadow: 0 2px 8px #0006;
        margin-bottom: 0.2rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    .spectacle-btn-modern:hover {
        background: #bb86fc;
        color: #121212;
        box-shadow: 0 4px 24px #bb86fc55;
    }
    .spectacle-infos-modern .spectacle-date {
        color: #03dac6;
        font-size: 0.98rem;
        margin-bottom: 0.1rem;
    }
    @media (max-width: 700px) {
        .main-spectacle-container { padding: 1.2rem 0; }
        .spectacle-card-modern { flex-direction: column; align-items: center; max-width: 98vw; padding: 1.1rem 0.7rem; }
        .spectacle-img-modern { width: 90vw; max-width: 220px; height: 140px; }
        .spectacle-infos-modern h1 { font-size: 1.1rem; }
    }
    </style>
</head>
<body>
    <canvas id="mask-bg"></canvas>
    <div class="main-spectacle-container">
        <div class="spectacle-card-modern">
            <div class="spectacle-img-modern">
                <?php if ($spectacle['image']): ?>
                    <img src="uploads/<?= htmlspecialchars($spectacle['image']) ?>" alt="Affiche">
                <?php else: ?>
                    <span class="material-icons" style="font-size:48px;color:#888;">image</span>
                <?php endif; ?>
            </div>
            <div class="spectacle-infos-modern">
                <h1><?= htmlspecialchars($spectacle['titre']) ?></h1>
                <div class="desc"><?= nl2br(htmlspecialchars($spectacle['description'])) ?></div>
                <div class="spectacle-date">
                    <?php if (!empty($spectacle['date'])): ?>
                        <span class="material-icons" style="font-size:1.1em;vertical-align:middle;">event</span>
                        <?= date('d/m/Y', strtotime($spectacle['date'])) ?>
                    <?php endif; ?>
                </div>
                <div class="spectacle-rating">
                    <?php
                    if ($nb_avis > 0) {
                        for ($i = 1; $i <= 5; $i++) {
                            $color = $i <= round($moyenne_note) ? '#FFD600' : '#888';
                            echo '<span class="material-icons star" style="color:' . $color . ';font-size:1.1em;">star</span>';
                        }
                        echo '<span style="font-size:0.98em;font-weight:bold;color:#03dac6;margin-left:0.12em;">' . $moyenne_note . '</span>';
                        echo '<span style="font-size:0.93em;color:#bdbdbd;margin-left:0.10em;">(' . $nb_avis . ')</span>';
                    } else {
                        echo '<span style="color:#888;">Aucun avis</span>';
                    }
                    ?>
                </div>
                <div class="spectacle-actions">
                    <form method="post" style="display:inline;">
                        <input type="hidden" name="favori_id" value="<?= $spectacle['id'] ?>">
                        <button type="submit" class="spectacle-btn-modern">
                            <span class="material-icons">
                                <?= $favori_existe ? 'star' : 'star_border' ?>
                            </span> <?= $favori_existe ? 'Retirer des favoris' : 'Ajouter aux favoris' ?>
                        </button>
                    </form>
                    <?php if ($reps->num_rows > 0): ?>
                        <?php while ($rep = $reps->fetch_assoc()): ?>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="reserver_rep_id" value="<?= $rep['id'] ?>">
                                <button type="submit" class="spectacle-btn-modern">
                                    <span class="material-icons">event_seat</span>
                                    Réserver<br>
                                    <span style="font-size:0.95rem;font-weight:400;">
                                        <?= htmlspecialchars($rep['date']) ?> à <?= htmlspecialchars($rep['heure']) ?>, <?= htmlspecialchars($rep['salle']) ?> (<?= htmlspecialchars($rep['ville']) ?>)
                                    </span>
                                </button>
                            </form>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <button class="spectacle-btn-modern" style="background:#444;cursor:not-allowed;">Non disponible</button>
                    <?php endif; ?>
                    <button class="spectacle-btn-modern" style="background:#222;color:#fff;" onclick="alert('Fonctionnalité à venir !')">
                        <span class="material-icons">ondemand_video</span> Bande d'annonce
                    </button>
                    <a href="avis_spectacle.php?id=<?= $spectacle['id'] ?>" class="spectacle-btn-modern" style="background:#FFD600;color:#222;text-decoration:none;">
                        <span class="material-icons">rate_review</span> Donner mon avis
                    </a>
                </div>
            </div>
        </div>
        <!-- Section avis utilisateurs -->
        <div style="max-width:540px;margin:2.2em auto 0 auto;">
            <h3 style="color:#FFD600;margin-bottom:0.7em;">Critiques et avis</h3>
            <?php if ($nb_avis > 0): ?>
                <?php foreach ($avis as $a): ?>
                    <div style="background:#232526;border-radius:1em;padding:1em 1.2em;margin-bottom:1.2em;position:relative;">
                        <div style="display:flex;align-items:center;gap:1em;">
                            <span style="font-weight:bold;color:#FFD600;">★ <?= (int)$a['note'] ?>/5</span>
                            <span style="color:#fff;font-weight:600;">"<?= htmlspecialchars($a['titre']) ?>"</span>
                            <span style="color:#bdbdbd;font-size:0.98em;">par <?= htmlspecialchars($a['prenom']) ?> <?= htmlspecialchars($a['nom']) ?>, le <?= date('d/m/Y H:i', strtotime($a['date'])) ?></span>
                        </div>
                        <div style="margin:0.7em 0 0.5em 0;color:#e0e0e0;"> <?= nl2br(htmlspecialchars($a['commentaire'])) ?> </div>
                        <form method="post" style="position:absolute;top:1em;right:1.2em;">
                            <input type="hidden" name="signaler_avis_id" value="<?= $a['id'] ?>">
                            <button type="submit" class="spectacle-btn-modern" style="background:#FFD600;color:#222;padding:0.3em 1em;font-size:0.95em;">Signaler</button>
                        </form>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div style="color:#888;">Aucun avis pour ce spectacle.</div>
            <?php endif; ?>
        </div>
    </div>
    <button onclick="window.location.href='client.php'" style="position:fixed;bottom:32px;right:32px;z-index:1000;background:#e50914;color:#fff;border:none;border-radius:2rem;padding:1rem 2.2rem;font-size:1.1rem;font-weight:700;box-shadow:0 2px 8px #0006;cursor:pointer;transition:background 0.2s;">← Retour à l'accueil</button>
</body>
</html>
<script>
// Animation de masques de théâtre emoji (canvas)
const maskImg = new window.Image();
maskImg.src = 'https://openmoji.org/data/color/svg/1F3AD.svg'; // OpenMoji SVG masque théâtre
const maskCanvas = document.getElementById('mask-bg');
const maskCtx = maskCanvas.getContext('2d');
let mw = window.innerWidth, mh = window.innerHeight;
maskCanvas.width = mw; maskCanvas.height = mh;
window.addEventListener('resize', () => {
    mw = window.innerWidth; mh = window.innerHeight;
    maskCanvas.width = mw; maskCanvas.height = mh;
});
const maskShapes = [];
function randomMask() {
    return {
        x: Math.random() * mw,
        y: mh + 40 + Math.random() * 80,
        r: 64 + Math.random() * 48,
        speed: 0.5 + Math.random() * 1.1,
        phase: Math.random() * Math.PI * 2,
        rot: Math.random() * Math.PI * 2,
        rotSpeed: (Math.random()-0.5)*0.01
    };
}
for (let i = 0; i < 14; i++) maskShapes.push(randomMask());
function drawMasks() {
    maskCtx.clearRect(0,0,mw,mh);
    for (let m of maskShapes) {
        if (maskImg.complete) {
            maskCtx.save();
            maskCtx.globalAlpha = 0.22;
            maskCtx.translate(m.x, m.y);
            maskCtx.rotate(m.rot);
            // Glow néon violet
            maskCtx.shadowColor = '#bb86fc';
            maskCtx.shadowBlur = 48;
            maskCtx.drawImage(maskImg, -m.r/2, -m.r/2, m.r, m.r);
            maskCtx.shadowBlur = 0;
            // Surimpression violet/rose
            maskCtx.globalAlpha = 0.32;
            maskCtx.globalCompositeOperation = 'source-atop';
            maskCtx.fillStyle = 'rgba(187,134,252,0.85)';
            maskCtx.fillRect(-m.r/2, -m.r/2, m.r, m.r);
            maskCtx.globalCompositeOperation = 'source-over';
            maskCtx.globalAlpha = 1;
            maskCtx.restore();
        }
        // Mouvement
        m.y -= m.speed + Math.sin(Date.now()/900 + m.phase)*0.5;
        m.x += Math.sin(Date.now()/1100 + m.phase)*0.5;
        m.rot += m.rotSpeed;
        if (m.y < -m.r) {
            Object.assign(m, randomMask());
            m.y = mh + 40 + Math.random()*80;
        }
    }
    requestAnimationFrame(drawMasks);
}
maskImg.onload = drawMasks;
</script> 