<?php
require_once 'db.php';
if (!isset($_GET['id'])) { header('Location: agenda_culturel.php'); exit(); }
$id = (int)$_GET['id'];
$evt = $conn->query("SELECT s.*, g.nom AS genre FROM spectacles s LEFT JOIN genres g ON s.genre_id = g.id WHERE s.id = $id")->fetch_assoc();
if (!$evt || strtolower($evt['genre']) !== 'evènements') { header('Location: agenda_culturel.php'); exit(); }
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($evt['titre']) ?> - Evènement</title>
    <link rel="stylesheet" href="client_pages.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <style>
        body { background: linear-gradient(120deg, #181818 0%, #232526 100%); color: #fff; font-family: 'Segoe UI', Arial, sans-serif; }
        .evt-container { max-width: 600px; margin: 3rem auto; background: #181818; border-radius: 2rem; box-shadow: 0 8px 32px #000a; padding: 2.5rem 2.5rem; }
        .evt-title { font-size: 2.2rem; font-weight: bold; color: #FFD600; margin-bottom: 1.2rem; text-align: center; }
        .evt-img { width: 100%; max-width: 340px; height: 220px; margin: 0 auto 1.5rem auto; display: flex; align-items: center; justify-content: center; border-radius: 1.5rem; overflow: hidden; background: #232526; }
        .evt-img img { width: 100%; height: 100%; object-fit: cover; border-radius: 1.5rem; }
        .evt-date { color: #e50914; font-size: 1.15rem; font-weight: 700; text-align: center; margin-bottom: 1.2rem; }
        .evt-desc { font-size: 1.13rem; color: #f5f5f5; margin-bottom: 2rem; text-align: center; }
        .evt-back { display: block; margin: 0 auto; background: #FFD600; color: #222; font-weight: bold; border-radius: 1.2rem; padding: 0.8rem 2.2rem; text-align: center; text-decoration: none; font-size: 1.1rem; transition: background 0.2s; }
        .evt-back:hover { background: #e50914; color: #fff; }
    </style>
</head>
<body>
<div class="evt-container">
    <div class="evt-title"><?= htmlspecialchars($evt['titre']) ?></div>
    <div class="evt-img">
        <?php if ($evt['image']): ?>
            <img src="uploads/<?= htmlspecialchars($evt['image']) ?>" alt="Affiche">
        <?php else: ?>
            <span class="material-icons" style="font-size:60px;color:#888;">image</span>
        <?php endif; ?>
    </div>
    <div class="evt-date">
        <?php if (!empty($evt['date'])): ?>
            <?= date('d/m/Y', strtotime($evt['date'])) ?>
        <?php endif; ?>
    </div>
    <div class="evt-desc">
        <?= nl2br(htmlspecialchars($evt['description'])) ?>
    </div>
    <a href="agenda_culturel.php" class="evt-back"><span class="material-icons" style="vertical-align:middle;margin-right:6px;">arrow_back</span>Retour à l'agenda</a>
</div>
</body>
</html> 