<?php
require_once 'db.php';
// Récupérer les genres pour le formulaire
$genres = $conn->query("SELECT * FROM genres ORDER BY nom");
// Ajout d'un événement (spectacle)
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $titre = $conn->real_escape_string($_POST['titre']);
    $description = $conn->real_escape_string($_POST['description']);
    $date = $conn->real_escape_string($_POST['date']);
    $genre_id = isset($_POST['genre_id']) && $_POST['genre_id'] !== '' ? (int)$_POST['genre_id'] : 'NULL';
    $image = null;
    // Gestion de l'upload d'image
    if (!is_dir('uploads')) { mkdir('uploads', 0777, true); }
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $image = uniqid('evt_', true) . '.' . $ext;
        move_uploaded_file($_FILES['image']['tmp_name'], 'uploads/' . $image);
    }
    $image_sql = $image ? "'$image'" : 'NULL';
    $conn->query("INSERT INTO spectacles (titre, description, image, date, genre_id) VALUES ('$titre', '$description', $image_sql, '$date', $genre_id)");
    $message = "Événement ajouté !";
}
// Liste des spectacles (événements)
$spectacles = $conn->query("SELECT * FROM spectacles ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Admin - Agenda culturel</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion de l'agenda culturel</h1>
        <?php if ($message): ?><div class="card" style="background:#d4edda;color:#155724;"> <?= htmlspecialchars($message) ?> </div><?php endif; ?>
        <div class="card">
            <h2>Ajouter un événement</h2>
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>Titre</label>
                    <input type="text" name="titre" required>
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea name="description" required></textarea>
                </div>
                <div class="form-group">
                    <label>Image (fichier)</label>
                    <input type="file" name="image" accept="image/*">
                </div>
                <div class="form-group">
                    <label>Date</label>
                    <input type="date" name="date" required>
                </div>
                <div class="form-group">
                    <label>Genre</label>
                    <select name="genre_id">
                        <option value="">Sélectionnez un genre</option>
                        <?php if ($genres) while ($g = $genres->fetch_assoc()): ?>
                            <option value="<?= $g['id'] ?>"><?= htmlspecialchars($g['nom']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Ajouter</button>
            </form>
        </div>
        <div class="card">
            <h2>Liste des événements</h2>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Titre</th>
                        <th>Description</th>
                        <th>Image</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($s = $spectacles->fetch_assoc()): ?>
                    <tr>
                        <td><?= $s['id'] ?></td>
                        <td><?= htmlspecialchars($s['titre']) ?></td>
                        <td><?= htmlspecialchars($s['description']) ?></td>
                        <td>
                            <?php if ($s['image']): ?>
                                <img src="uploads/<?= htmlspecialchars($s['image']) ?>" alt="Affiche" style="max-width:60px;max-height:80px;border-radius:6px;">
                            <?php endif; ?>
                        </td>
                        <td><?= isset($s['date']) ? htmlspecialchars($s['date']) : '' ?></td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>
</body>
</html> 