<?php
require_once 'db.php';
// Résiliation
if (isset($_POST['resilier_id'])) {
    $id = (int)$_POST['resilier_id'];
    $conn->query("UPDATE abonnements SET date_fin = NOW() WHERE id = $id");
}
// Suppression
if (isset($_POST['supprimer_id'])) {
    $id = (int)$_POST['supprimer_id'];
    $conn->query("DELETE FROM abonnements WHERE id = $id");
}
$abos = $conn->query("SELECT a.*, u.nom, u.prenom FROM abonnements a JOIN utilisateurs u ON a.user_id = u.id ORDER BY a.date_debut DESC");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Admin - Abonnements</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion des abonnements</h1>
        <div class="card">
            <table>
                <thead>
                    <tr>
                        <th>Utilisateur</th>
                        <th>Date début</th>
                        <th>Date fin</th>
                        <th>Montant</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($a = $abos->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($a['prenom'].' '.$a['nom']) ?></td>
                        <td><?= htmlspecialchars($a['date_debut']) ?></td>
                        <td><?= $a['date_fin'] ? htmlspecialchars($a['date_fin']) : '<span style="color:#FFD600">En cours</span>' ?></td>
                        <td><?= htmlspecialchars($a['montant']) ?> €</td>
                        <td>
                            <?php if (!$a['date_fin'] || strtotime($a['date_fin']) > time()): ?>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="resilier_id" value="<?= $a['id'] ?>">
                                <button type="submit" class="btn btn-danger">Résilier</button>
                            </form>
                            <?php endif; ?>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Supprimer définitivement cet abonnement ?');">
                                <input type="hidden" name="supprimer_id" value="<?= $a['id'] ?>">
                                <button type="submit" class="btn btn-danger" style="background:#b71c1c;">Supprimer</button>
                            </form>
                            <?php if ($a['date_fin'] && strtotime($a['date_fin']) <= time()): ?>
                                <span style="color:#888;">Résilié</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>
</body>
</html> 