<?php
require_once 'db.php';
// Ajout d'une réservation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $representation_id = (int)$_POST['representation_id'];
    $nom_client = $conn->real_escape_string($_POST['nom_client']);
    $email_client = $conn->real_escape_string($_POST['email_client']);
    $nb_places = (int)$_POST['nb_places'];
    $conn->query("INSERT INTO reservations (representation_id, nom_client, email_client, nb_places) VALUES ($representation_id, '$nom_client', '$email_client', $nb_places)");
    header('Location: reservations.php');
    exit();
}
// Suppression d'une réservation
if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $conn->query("DELETE FROM reservations WHERE id=$id");
    header('Location: reservations.php');
    exit();
}
// Liste des représentations pour le formulaire
$representations = $conn->query("
    SELECT r.id, s.titre AS spectacle, sa.nom AS salle, r.date, r.heure
    FROM representations r
    JOIN spectacles s ON r.spectacle_id = s.id
    JOIN salles sa ON r.salle_id = sa.id
    ORDER BY r.date DESC, r.heure DESC
");
// Liste des réservations
$reservations = $conn->query("
    SELECT res.*, s.titre AS spectacle, sa.nom AS salle, r.date, r.heure
    FROM reservations res
    JOIN representations r ON res.representation_id = r.id
    JOIN spectacles s ON r.spectacle_id = s.id
    JOIN salles sa ON r.salle_id = sa.id
    ORDER BY res.date_reservation DESC
");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Réservations</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion des Réservations</h1>
        <div class="card">
            <h2>Ajouter une réservation</h2>
            <form method="post">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>Représentation</label>
                    <select name="representation_id" required>
                        <option value="">Sélectionnez une représentation</option>
                        <?php while ($r = $representations->fetch_assoc()): ?>
                            <option value="<?= $r['id'] ?>">
                                <?= htmlspecialchars($r['spectacle']) ?> - <?= htmlspecialchars($r['salle']) ?> - <?= htmlspecialchars($r['date']) ?> <?= htmlspecialchars($r['heure']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Nom du client</label>
                    <input type="text" name="nom_client" required>
                </div>
                <div class="form-group">
                    <label>Email du client</label>
                    <input type="email" name="email_client" required>
                </div>
                <div class="form-group">
                    <label>Nombre de places</label>
                    <input type="number" name="nb_places" min="1" value="1" required>
                </div>
                <button type="submit" class="btn btn-primary">Ajouter</button>
            </form>
        </div>
        <div class="card">
            <h2>Liste des réservations</h2>
            <table>
                <thead>
                    <tr>
                        <th>Spectacle</th>
                        <th>Salle</th>
                        <th>Date</th>
                        <th>Heure</th>
                        <th>Client</th>
                        <th>Email</th>
                        <th>Places</th>
                        <th>Date réservation</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($res = $reservations->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($res['spectacle']) ?></td>
                        <td><?= htmlspecialchars($res['salle']) ?></td>
                        <td><?= htmlspecialchars($res['date']) ?></td>
                        <td><?= htmlspecialchars($res['heure']) ?></td>
                        <td><?= htmlspecialchars($res['nom_client']) ?></td>
                        <td><?= htmlspecialchars($res['email_client']) ?></td>
                        <td><?= htmlspecialchars($res['nb_places']) ?></td>
                        <td><?= htmlspecialchars($res['date_reservation']) ?></td>
                        <td>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Supprimer cette réservation ?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?= $res['id'] ?>">
                                <button type="submit" class="btn btn-danger">Supprimer</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>
</body>
</html>